<?php
	/**
	 * hostip.info API wrapper
	 * Copyright (C) 2008. IPDistance.com
	 */
	require_once dirname (__FILE__) ."/class.http.php";
	
	/**
	 * host ip api wrapper class
	 */
	class hostIp
	{
		//constructor
		function hostIp ()
		{
			
		}
		
		/**
		 * get locations
		 */
		function getLocations ($ip)
		{
			$arrResult = array ();
			$arrResult["Country"] = "";
			$arrResult["City"] = "";
			$arrResult["Longitude"] = "";
			$arrResult["Latitude"] = "";
			
			$httpClient = new http( HTTP_V11, false); 
			$httpClient->host = "api.hostip.info"; 
			
			$url = "/get_html.php?ip=". urlencode ($ip) ."&position=true";
			if ($httpClient->get ($url ) == HTTP_STATUS_OK) 
			{
				$httpResult = $httpClient->get_response_body();
				$httpResult = str_replace ("\r", "", $httpResult);
$httpResult = str_replace ("\n\n", "\n", $httpResult);
				$arrHttpResult = explode ("\n", $httpResult);
				foreach ($arrHttpResult as $index => $value)
				{
					$arrValue = explode (": ", $value);
					if ($index == 0)
						$arrResult["Country"] = $arrValue[1];
					
					if ($index == 1)
						$arrResult["City"] = $arrValue[1];
					
					if ($index == 2)
						$arrResult["Latitude"] = $arrValue[1];
						
					if ($index == 3)
						$arrResult["Longitude"] = $arrValue[1];
				}
			}
			
			return $arrResult;
			
		}
		
		//get flag image
		function getImgFlag ($ip)
		{
			return "http://api.hostip.info/flag.php?ip=". urlencode ($ip);
		}
		
		//get ip address
		function getIPAddress ($hostname)
		{
			return gethostbyname ($hostname);
		}
		
		//get host name
		function getHostName ($ip)
		{
			return gethostbyaddr ($ip);
		}
		
		/**
		 *
		 */
		function isIPAddress ($hostname)
		{
			$hostname = str_replace (" ", "", $hostname);
			if (preg_match ("/^[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}$/", $hostname))
				return true;
			else
				return false;
		}
		
		//get related ip address
		function getIPAdressRelated ($hostname)
		{
			return gethostbynamel ($hostname);
		}
		
		//get distance
		function getDistance($lat1, $lon1, $lat2, $lon2, $unit) 
		{ 
			if (empty ($lat1) || empty ($lon1) || empty ($lat2) || empty ($lon2))
				return false;
		
			  $theta = $lon1 - $lon2; 
			  $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta)); 
			  $dist = acos($dist); 
			  $dist = rad2deg($dist); 
			  $miles = $dist * 60 * 1.1515;
			  $unit = strtoupper($unit);

			  if ($unit == "K") {
				return round ($miles * 1.609344, 2); 
			  } else if ($unit == "N") {
				  return round ($miles * 0.8684, 2);
				} else {
					return round ($miles, 2);
				  }
			}
	}	

?>