<?php
	/**
	 * Main File
	 * 
	 *  To show the result in your php page, you can include this file into your php page example:
	 * <?php
	 *     include dirname (__FILE__) . "/whatsyourip/index.php";
	 * ?>
	 *
	 * Copyright (C) 2008. IPDistance.com
	 */
	require_once dirname (__FILE__) . "/lib/class.hostIp.php";
	require_once dirname (__FILE__) . "/config.php";
	
	$IP = $_SERVER['REMOTE_ADDR'];
	$hostname = @gethostbyaddr ($IP);
	
	//get ip informations
	$hostIp = new hostIp ();
	$locations1 = $hostIp->getLocations ($IP);
	
	$cityInfo = $locations1["City"];
	$countryInfo = $locations1["Country"];
	
	if (!empty ($cityInfo))
		$countryInfo = $cityInfo . ", ". $countryInfo;
	
	$latitudeInfo = $locations1["Latitude"];
	$longitudeInfo = $locations1["Longitude"];
	$imgFlag = $hostIp->getImgFlag ($IP);

?>
<style>
<?php
	include dirname (__FILE__) . "/style.css";
?>
</style>

<span id="title">Your computer's IP address is:</span>
<br>
<span id="result"><?php echo $IP ?></span>
<br>

<?php
	if (!empty ($hostname))
	{
?>
<br>
<span id="title">Your computer's hostname is:</span>
<br>
<span id="result"><?php echo $hostname?></span>
<br>
<?php
	}
?>

<?php
	if (!empty ($countryInfo))
	{
?>
<br>
<span id="title">Your location is:</span>
<br>
<span id="result"><?php echo $countryInfo ?> &nbsp;
<img src='<?=$imgFlag?>' height='15'></span>
<?php
	}
?>

<?php

if (!empty ($latitudeInfo) && !empty ($longitudeInfo))
{
?>
<head>
   <script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=<?php echo $googleMapsAPIKey?>"
            type="text/javascript"></script>
</head>
    <script type="text/javascript">
    
    function initialize() {
      if (GBrowserIsCompatible()) {
       var map = new GMap2(document.getElementById("map_canvas"));
		var point = new GLatLng(<?php echo $latitudeInfo?>, <?php echo $longitudeInfo?>);
		map.setCenter(point, 2);
		
        map.addControl(new GSmallMapControl());
        map.addControl(new GMapTypeControl());
		
		
		var marker = new GMarker(point);
		GEvent.addListener(marker, "click", function() {
            marker.openInfoWindowHtml("Your IP (<?php echo $IP?>) location.");
          });
		map.addOverlay(marker);
		
        }
      }

    </script>
  
  <body onload="initialize()" onunload="GUnload()">
    <div id="map_canvas" style="width: <?php echo $mapWidth?>px; height: <?php echo $mapHeight?>px"></div>
	</body>
	
<?php
}
?>
<br>
<span id="powered_by">powered by <a href="http://www.ipdistance.com">IP Tools</a></span>